TITLE 								         { exa054.pde }
   'Charged Wires, Gauss Integral'		
SELECT
   spectral_colors	
DEFINITIONS                                     		
   Lx=1     Ly=1     d0=Ly/2     r0=8e-2     qw=1	{ Both charges positive }
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U=-qw*c*ln(x^2+(y+d0)^2)- qw*c*ln(x^2+(y-d0)^2)
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   D=eps0*E						{ Vector D }
BOUNDARIES
region 'domain'
   start 'box' (-Lx,-Ly)  line to (Lx,-Ly) to (Lx,Ly)  to (-Lx,Ly) close
   start(r0,-d0) arc( center=0,-d0) angle=360	{ Exclude circle }
   start(r0,d0) arc( center=0,d0) angle=360	{ Exclude circle }
feature  start 'half_box' (-Lx,-Ly)  			{ For line integral }
   line to (Lx,-Ly) to (Lx,0) to (-Lx,0) to (-Lx,-Ly)
PLOTS
   elevation( normal(D)) on 'box'     elevation( normal(D)) on 'half_box'
END

